/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.render;

import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class Tesselator {
    private static final int MAX_FLOATS = 524288;
    private static final int VERTEX_SIZE = 3;
    private static final int COLOR_SIZE = 3;
    private static final int TEXTURE_SIZE = 2;
    private final FloatBuffer buffer = BufferUtils.createFloatBuffer(524288);
    private final float[] vertexData = new float[524288];
    private int vertexCount;
    private int bufferIndex;
    private int stride;
    private int drawMode = 7;
    private boolean hasColor;
    private boolean hasTexture;
    private float currentU;
    private float currentV;
    private float currentR;
    private float currentG;
    private float currentB;
    public static final Tesselator INSTANCE = new Tesselator();

    private Tesselator() {
        this.reset();
    }

    public void begin(int mode) {
        this.reset();
        this.drawMode = mode;
    }

    public Tesselator setTexture(float u, float v) {
        if (!this.hasTexture) {
            this.stride += 2;
            this.hasTexture = true;
        }
        this.currentU = u;
        this.currentV = v;
        return this;
    }

    public Tesselator setColor(float r, float g2, float b2) {
        if (!this.hasColor) {
            this.stride += 3;
            this.hasColor = true;
        }
        this.currentR = r;
        this.currentG = g2;
        this.currentB = b2;
        return this;
    }

    public Tesselator addVertex(float x, float y, float z) {
        int verticesPerPrimitive;
        int n = this.drawMode == 7 ? 4 : (verticesPerPrimitive = this.drawMode == 1 ? 2 : 1);
        if (this.vertexCount % verticesPerPrimitive == 0 && this.bufferIndex >= 524288 - this.stride * verticesPerPrimitive) {
            this.flush();
        }
        if (this.hasTexture) {
            this.vertexData[this.bufferIndex++] = this.currentU;
            this.vertexData[this.bufferIndex++] = this.currentV;
        }
        if (this.hasColor) {
            this.vertexData[this.bufferIndex++] = this.currentR;
            this.vertexData[this.bufferIndex++] = this.currentG;
            this.vertexData[this.bufferIndex++] = this.currentB;
        }
        this.vertexData[this.bufferIndex++] = x;
        this.vertexData[this.bufferIndex++] = y;
        this.vertexData[this.bufferIndex++] = z;
        ++this.vertexCount;
        return this;
    }

    public Tesselator addVertexWithUV(float x, float y, float z, float u, float v) {
        this.setTexture(u, v);
        return this.addVertex(x, y, z);
    }

    public Tesselator addVertex(float[] pos) {
        if (pos.length != 3) {
            throw new IllegalArgumentException("Position array must have 3 elements");
        }
        return this.addVertex(pos[0], pos[1], pos[2]);
    }

    public Tesselator addVertexWithUV(float[] pos, float[] uv) {
        if (pos.length != 3) {
            throw new IllegalArgumentException("Position array must have 3 elements");
        }
        if (uv.length != 2) {
            throw new IllegalArgumentException("UV array must have 2 elements");
        }
        this.setTexture(uv[0], uv[1]);
        return this.addVertex(pos[0], pos[1], pos[2]);
    }

    public void flush() {
        if (this.vertexCount == 0) {
            return;
        }
        this.buffer.clear();
        this.buffer.put(this.vertexData, 0, this.bufferIndex);
        this.buffer.flip();
        if (this.hasTexture && this.hasColor) {
            GL11.glInterleavedArrays(10794, 0, this.buffer);
        } else if (this.hasTexture) {
            GL11.glInterleavedArrays(10791, 0, this.buffer);
        } else if (this.hasColor) {
            GL11.glInterleavedArrays(10788, 0, this.buffer);
        } else {
            GL11.glInterleavedArrays(10785, 0, this.buffer);
        }
        GL11.glEnableClientState(32884);
        if (this.hasTexture) {
            GL11.glEnableClientState(32888);
        }
        if (this.hasColor) {
            GL11.glEnableClientState(32886);
        }
        GL11.glDrawArrays(this.drawMode, 0, this.vertexCount);
        GL11.glDisableClientState(32884);
        if (this.hasTexture) {
            GL11.glDisableClientState(32888);
        }
        if (this.hasColor) {
            GL11.glDisableClientState(32886);
        }
        this.reset();
    }

    private void reset() {
        this.vertexCount = 0;
        this.bufferIndex = 0;
        this.stride = 3;
        this.hasColor = false;
        this.hasTexture = false;
        this.currentV = 0.0f;
        this.currentU = 0.0f;
        this.currentB = 1.0f;
        this.currentG = 1.0f;
        this.currentR = 1.0f;
        this.buffer.clear();
    }
}

